-- by modelleicher
-- allows you to paint all the CombinedLayers within a Map not just the ones added to the map.xml
-- Date: 25.11.2024
-- If I had known how easy this was I would've done that years ago.. always annoyed me if the mapper didn't specify many textures to paint ingame. Texture variation is what makes or breaks a good farm build.

allTheGroundTextures = {}


function allTheGroundTextures.initTerrain(self, superFunc, terrain)

	-- call superFunc we don't want anything from that actually
	superFunc(self, terrain)

	-- get the number of terrain layers 
	local layers = getTerrainNumOfLayers(terrain)

	-- cycle all layers 
	for i = 0, layers - 1 do
		local layerName = getTerrainLayerName(terrain, i)
		
		-- if the layerName is the same in lower and upper case we found a combined layer (because those are all caps if done like a default map)
		if string.upper(layerName) == layerName then
			
			-- do some string manipulation to change the all caps layer name to a nice name for the UI
			local layerNameUI = ""
			local layerNameParts = string.split(layerName, "_")
			
			for i=1, #layerNameParts do
				
				local firstLetter = string.sub(layerNameParts[i], 1, 1)
				
				local otherLetters = string.sub(layerNameParts[i], 2)
				
				layerNameUI = layerNameUI..firstLetter..string.lower(otherLetters).." "
			end
			
			-- create groundType table and add it to the other mappings
			local groundType = {typeName = tostring(layerName), layerName = tostring(layerName), title = tostring(layerNameUI)}
			self.groundTypeMappings[tostring(layerName)] = groundType
		end
	end
	
end
GroundTypeManager.initTerrain = Utils.overwrittenFunction(GroundTypeManager.initTerrain , allTheGroundTextures.initTerrain)