--Author:	nilBrain
--Node:		Extends the number of Farms.
--Date:		26.11.2020
--Update:	15.08.2022

MoreNumFarms = {};

MoreNumFarms.FARM_AMOUNT = 20; --<--For more farms, you need to change this value.
MoreNumFarms.MOD_NAME = g_currentModName;
MoreNumFarms.MOD_DIR = g_currentModDirectory;

if not g_modIsLoaded[MoreNumFarms.MOD_NAME] then
	return;
end;


local init = function()
	FarmManager.MAX_NUM_FARMS = MoreNumFarms.FARM_AMOUNT;
	FarmManager.MAX_FARM_ID = FarmManager.MAX_NUM_FARMS;
	FarmManager.FARM_ID_SEND_NUM_BITS = math.floor(math.sqrt(FarmManager.MAX_NUM_FARMS)+1);
	FarmManager.INVALID_FARM_ID = FarmManager.FARM_ID_SEND_NUM_BITS^2 - 1;

	local xmlFile = XMLFile.loadIfExists("farmColors", MoreNumFarms.MOD_DIR .. "farmColors.xml", MoreNumFarms.xmlSchema);
	if xmlFile ~= nil then
		for i=1, FarmManager.MAX_NUM_FARMS do
			local xmlKey = string.format("farmColors.farm(%d)#color", i-1);
			Farm.COLORS[i] = xmlFile:hasProperty(xmlKey) and xmlFile:getValue(xmlKey, nil, true) or Farm.COLORS[(i%8)+1];
		end;
	end;

	local uv = Farm.ICON_UVS;
	for i=#uv, FarmManager.MAX_NUM_FARMS do
	--for i=1, FarmManager.MAX_NUM_FARMS do
		--Farm.ICON_UVS[i] = uv[i%7];
		table.insert(Farm.ICON_UVS, uv[(i%8)+1]);
	end;
end;

g_xmlManager:addCreateSchemaFunction(function()
	MoreNumFarms.xmlSchema = XMLSchema.new("farmColors");
end);

g_xmlManager:addInitSchemaFunction(function()
	local schema = MoreNumFarms.xmlSchema;

	schema:register(XMLValueType.COLOR, "farmColors.farm(?)#color", "Farm Color");

	init();
end);

local oldStoreAvailableColors = EditFarmDialog.storeAvailableColors;
function EditFarmDialog:storeAvailableColors(editingFarmId)
	oldStoreAvailableColors(self, editingFarmId);

	for i=#self.availableColors, 9, -1 do
		table.remove(self.availableColors, i);
		self.availableColorIndexMap[i] = nil;
	end;
end;